<?php

$this->pageTitle = 'Biura - ' . Yii::app()->name;

$this->breadcrumbs = array(
	'Biura'
);


?>
<h1>Biura</h1>

<?php

$this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'biuro-grid',
	'dataProvider'=>$model->with('budynek')->search(),
	'filter'=>$model,
	'htmlOptions' => array('class' => 'tDefault'),
	'columns'=>array(
		'id',
		array(
			'name' => 'powierzchnia',
			'value' => 'number_format($data->powierzchnia, 2, ",", ".")'
		),
		'maxPracownikow',
		array(
			'name' => 'cenaWynajem',
			'value' => 'number_format($data->cenaWynajem, 2, ",", ".")'
		),
		array(
			'name' => 'cenaMedia',
			'value' => 'number_format($data->cenaMedia, 2, ",", ".")'
		),
		array(
			'name' => 'idBudynku',
			'value' => '"<a target=\"_blank\" href=\"" . Yii::app()->createUrl("/administration/budynek/view", array("id" => $data->idBudynku)) . "\">" . $data->budynek->nazwa . "</a>"',
			'type' => 'raw'
		),
		array(
			'class'=>'CButtonColumn',
			'template'=>'{view}{update}'
		),
	),
));

?>